<?php 
/* Crea un popup para instalar como pwa y mandar notificaciones push con "Native Notify.com"

Archivos que debes poner en raiz:
- manifest.json: Manifest para el PWA.  --- lo ajustas segun el nombre de la app
- iconos en esos dos tamaños 192px y 512px
- OneSignalSDKWorker.js --- para push, aunque haya un cdn ya requiere ambos
*/

// Puedes ponerlo en tu functions.php o CJT/Code Snippets plugin:
add_action('wp_head', function() {
    ?>
    <!-- Con esto forzas refresh en el cache de la pwa al refrescar el # de v, 
    si urge aunque al cambiar html también a lo mejor actualiza solo-->
    <link rel="stylesheet" href="/estilos.css?v=2">
    <script src="/miscript.js?v=2"></script>

    <!-- PWA Base -->
    <link rel="manifest" href="/manifest.json">
    <!--<meta name="theme-color" content="#ffffff"> Debe existir creo? pero seguro lo pones en otro lado-->

    <!-- Código de OneSignal para notif push todo se configura alla aparte necesitas -->
    <script src="https://cdn.onesignal.com/sdks/web/v16/OneSignalSDK.page.js" defer></script>
    <script>
      window.OneSignalDeferred = window.OneSignalDeferred || [];
      OneSignalDeferred.push(async function(OneSignal) {
        await OneSignal.init({
          appId: "db49734d-2d5e-43bc-9a2e-9c6ca2f85ce0",
        });
      });
    </script>
<?php
});
?>

<script>jQuery(document).ready(function($) {
    //Popups y las cookies para que no aparezca cada page load
    let deferredPrompt;

    function isSafariMobile() {
        var ua = window.navigator.userAgent.toLowerCase();
        return ua.includes('iphone') || ua.includes('ipad') || (ua.includes('macintosh') && 'ontouchend' in document);
    }

    function isChromeMobile() {
        var ua = window.navigator.userAgent.toLowerCase();
        return ua.includes('android') && ua.includes('chrome');
    }

    //Cookie para el "close" del popup
    function shouldShowPopup() {
        const closedAt = localStorage.getItem("pwaPopupClosedAt");
        if (!closedAt) return true;
        const closedDate = new Date(parseInt(closedAt));
        const now = new Date();
        const differenceInDays = (now - closedDate) / (1000 * 60 * 60 * 24);
        return differenceInDays >= 7; //Cada cuanto aparece el popup de nuevo...
    }

    if (shouldShowPopup()) {
        if (isChromeMobile()) {
            window.addEventListener('beforeinstallprompt', (e) => {
                e.preventDefault();
                deferredPrompt = e;
                $("#customInstallPrompt").fadeIn();
            });
        } else if (isSafariMobile()) {
            if (!window.navigator.standalone) { // solo si NO está instalada
                $("#customInstallPromptSafari").fadeIn();
            }
        }
    }

    $("#addToHomeButton").on("click", function() {
        if (deferredPrompt) {
            deferredPrompt.prompt();
            deferredPrompt.userChoice.then((choiceResult) => {
                deferredPrompt = null;
                $("#customInstallPrompt").fadeOut();
            });
        }
    });

    $("#closePrompt, #closePromptSafari").on("click", function() {
        $(".install-popup").fadeOut();
        localStorage.setItem("pwaPopupClosedAt", Date.now());
    });
});</script>

<!-- Popup para Chrome Android -->
<div id="customInstallPrompt" class="install-popup" style="display:none;">
    <p class="install-text">¿Quieres instalar la app?<br>Te llegarán notificaciones del evento y será más fácil de usar en tu teléfono.</p>
    <button id="addToHomeButton" class="install-button">Agregar</button>&nbsp;&nbsp;
    <a id="closePrompt" class="install-close">Cerrar</a>
</div>

<!-- Popup para Safari iPhone -->
<div id="customInstallPromptSafari" class="install-popup" style="display:none;">
    <p class="install-text">¿Quieres instalar la app?<br>Te llegarán notificaciones del evento y será más fácil de usar en tu teléfono.</p>
    <p class="install-instruction">En Safari, presiona el botón <strong>Compartir</strong> <span style="font-size:20px;">[&#x1F4E4;]</span> y elige <strong>"Agregar a inicio"</strong>.</p>&nbsp;
    <a id="closePromptSafari" class="install-close">Cerrar</a>
</div>

<style>
/*Estilos del popup*/
.install-popup {
    display: none;
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 90%;
    max-width: 400px;
    background: white;
    padding: 20px;
    border-radius: 10px;
    box-shadow: 0px 0px 15px rgba(0,0,0,0.3);
    z-index: 9999;
    text-align: center;
}

.install-text {
    font-size: 18px;
    margin-bottom: 15px;
    font-family: 'Cormorant Garamond', serif;
}

.install-instruction {
    font-size: 16px;
    font-family: 'Cormorant Garamond', serif;
}

.install-button, .install-close {
    text-decoration: none;
    padding: 10px 15px;
    border-radius: 5px;
    cursor: pointer;
    font-size: 16px;
    font-family: 'Cormorant Garamond', serif;
    font-weight: bold;
    border: none;
}

.install-button {
    background-color: #bd945a;
    color: white;
}
.install-button:hover {
    background-color: #a67f4f;
}
.install-close {
    background-color: gray;
    color: white !important;
}
</style>